#ifndef __CANOPEN_APM_ERROR_H
#define __CANOPEN_APM_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// CANopen Master Application Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CANOPEN_APM_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_CANOPEN_APM_COMMAND_INVALID ((TLR_RESULT)0xC0490001L)

//
// MessageId: TLR_I_CANOPEN_APM_CONFIG_LOCK
//
// MessageText:
//
//  Configuration is locked.
//
#define TLR_I_CANOPEN_APM_CONFIG_LOCK    ((TLR_RESULT)0x40490002L)

//
// MessageId: TLR_E_CANOPEN_APM_PACKET_LENGTH
//
// MessageText:
//
//  Invalid packet length.
//
#define TLR_E_CANOPEN_APM_PACKET_LENGTH  ((TLR_RESULT)0xC0490003L)

//
// MessageId: TLR_E_CANOPEN_APM_WATCHDOG_PARAMETER
//
// MessageText:
//
//  Invalid parameter for watchdog.
//
#define TLR_E_CANOPEN_APM_WATCHDOG_PARAMETER ((TLR_RESULT)0xC0490004L)

//
// MessageId: TLR_I_CANOPEN_APM_OPEN_DBM_FILE
//
// MessageText:
//
//  Database file not found.
//
#define TLR_I_CANOPEN_APM_OPEN_DBM_FILE  ((TLR_RESULT)0x40490005L)

//
// MessageId: TLR_E_CANOPEN_APM_DATASET
//
// MessageText:
//
//  Failed to open configuration dataset.
//
#define TLR_E_CANOPEN_APM_DATASET        ((TLR_RESULT)0xC0490006L)

//
// MessageId: TLR_E_CANOPEN_APM_TABLE_GLOBAL
//
// MessageText:
//
//  Failed to open GLOBAL configuration dataset.
//
#define TLR_E_CANOPEN_APM_TABLE_GLOBAL   ((TLR_RESULT)0xC0490007L)

//
// MessageId: TLR_E_CANOPEN_APM_TABLE_BUS_CAN
//
// MessageText:
//
//  Failed to open BUS_CAN configuration dataset.
//
#define TLR_E_CANOPEN_APM_TABLE_BUS_CAN  ((TLR_RESULT)0xC0490008L)

//
// MessageId: TLR_E_CANOPEN_APM_TABLE_BUS_CAN_EXT
//
// MessageText:
//
//  Failed to open BUS_CAN_EXT configuration dataset.
//
#define TLR_E_CANOPEN_APM_TABLE_BUS_CAN_EXT ((TLR_RESULT)0xC0490009L)

//
// MessageId: TLR_E_CANOPEN_APM_TABLE_NODES
//
// MessageText:
//
//  Failed to open NODES configuration dataset.
//
#define TLR_E_CANOPEN_APM_TABLE_NODES    ((TLR_RESULT)0xC049000AL)

//
// MessageId: TLR_E_CANOPEN_APM_WATCHDOG_ACTIVATE
//
// MessageText:
//
//  Failed to activate watchdog supervision.
//
#define TLR_E_CANOPEN_APM_WATCHDOG_ACTIVATE ((TLR_RESULT)0xC049000BL)

//
// MessageId: TLR_E_CANOPEN_APM_SIZE_TABLE_BUS_CAN
//
// MessageText:
//
//  Invalid size of BUS_CAN configuration dataset.
//
#define TLR_E_CANOPEN_APM_SIZE_TABLE_BUS_CAN ((TLR_RESULT)0xC049000CL)

//
// MessageId: TLR_E_CANOPEN_APM_SIZE_TABLE_BUS_CAN_EXT
//
// MessageText:
//
//  Invalid size of BUS_CAN_EXT configuration dataset.
//
#define TLR_E_CANOPEN_APM_SIZE_TABLE_BUS_CAN_EXT ((TLR_RESULT)0xC049000DL)

//
// MessageId: TLR_E_CANOPEN_APM_NODE_ALREADY_CONFIGURED
//
// MessageText:
//
//  Node already configured.
//
#define TLR_E_CANOPEN_APM_NODE_ALREADY_CONFIGURED ((TLR_RESULT)0xC049000EL)

//
// MessageId: TLR_E_CANOPEN_APM_INVALID_NODE_ID
//
// MessageText:
//
//  Invalid Node ID.
//
#define TLR_E_CANOPEN_APM_INVALID_NODE_ID ((TLR_RESULT)0xC049000FL)

//
// MessageId: TLR_E_CANOPEN_APM_DATABASE_FOUND
//
// MessageText:
//
//  Configuration database found.
//
#define TLR_E_CANOPEN_APM_DATABASE_FOUND ((TLR_RESULT)0xC0490010L)

//
// MessageId: TLR_E_CANOPEN_APM_REQUEST_RUNNING
//
// MessageText:
//
//  Request already running.
//
#define TLR_E_CANOPEN_APM_REQUEST_RUNNING ((TLR_RESULT)0xC0490011L)




#endif  //__CANOPEN_APM_ERROR_H

